// Franzis - Programmieren mit KI - Bausatz - Niklas Heinzel - 2025
// 3_RGB-und-Fototransistor-Skript

// Definition der Pins
const int redPin = 2;        // Pin D2 steuert die rote LED-Komponente
const int greenPin = 3;      // Pin D3 steuert die grüne LED-Komponente
const int bluePin = 4;       // Pin D4 steuert die blaue LED-Komponente
const int photoPin = A0;     // Analoger Pin A0 liest den Fototransistor-Wert

void setup() {
  pinMode(redPin, OUTPUT);     // Pin D2 (Rot) als Ausgang konfigurieren
  pinMode(greenPin, OUTPUT);   // Pin D3 (Grün) als Ausgang konfigurieren
  pinMode(bluePin, OUTPUT);    // Pin D4 (Blau) als Ausgang konfigurieren
  pinMode(photoPin, INPUT);    // Pin A0 (Fototransistor) als Eingang konfigurieren

  // LEDs initial ausschalten (bei gemeinsamer Anode: HIGH bedeutet aus)
  digitalWrite(redPin, HIGH);
  digitalWrite(greenPin, HIGH);
  digitalWrite(bluePin, HIGH);

  Serial.begin(9600);          // Serielle Kommunikation starten (zur Debugging-Hilfe)
}

void loop() {
  int photoValue = analogRead(photoPin); // Lies den Fototransistor-Wert (0–1023)
  Serial.println(photoValue);           // Ausgabe des Werts im seriellen Monitor

  // Basierend auf dem Fototransistor-Wert die LED-Farbe einstellen
  if (photoValue < 50) {
    setRGB(LOW, HIGH, HIGH);  // Dunkel -> Rot
  } else if (photoValue < 200) {
    setRGB(LOW, LOW, HIGH);   // Halbdunkel -> Orange (Rot + Grün mischen)
  } else {
    setRGB(HIGH, LOW, HIGH);  // Hell -> Grün
  }

  delay(100); // Kurze Verzögerung, um die LED-Flackern zu vermeiden
}

// Funktion, um die RGB-Pins basierend auf den übergebenen Werten zu steuern
void setRGB(int redValue, int greenValue, int blueValue) {
  digitalWrite(redPin, redValue);   // Rot: LOW = an, HIGH = aus (gemeinsame Anode)
  digitalWrite(greenPin, greenValue); // Grün: LOW = an, HIGH = aus (gemeinsame Anode)
  digitalWrite(bluePin, blueValue);  // Blau: LOW = an, HIGH = aus (gemeinsame Anode)
}

